<?php
/**
 * Created by PhpStorm.
 * User: Dungdt
 * Date: 12/15/2015
 * Time: 3:19 PM
 */


if (!class_exists('ST_Billplz_Payment_Gateway')) {
    class ST_Billplz_Payment_Gateway extends STAbstactPaymentGateway
    {
        static private $_ints;
        private $default_status = true;
        private $_gatewayObject = null;
        private $_gateway_id = 'st_billplz';

        private $apiKey = '';
        private $collectionId = '';
        private $xsignatureKey = '';
        private $notification = '';

        function __construct()
        {
            add_filter('st_payment_gateway_st_billplz_name', array($this, 'get_name'));
            try {
                $this->_gatewayObject = '';

            } catch (Exception $e) {
                $this->default_status = false;
            }
        }


        function get_option_fields()
        {
            return array(
                array(
                    'id' => 'billplz_api_secret_key',
                    'label' => __('API Secret Key', 'traveler-billplz'),
                    'type' => 'text',
                    'section' => 'option_pmgateway',
                    'desc' => __('API Secret Key', 'traveler-billplz'),
                    'condition' => 'pm_gway_st_billplz_enable:is(on)'
                ),
                array(
                    'id' => 'billplz_collection_id',
                    'label' => __('Collection ID', 'traveler-billplz'),
                    'type' => 'text',
                    'section' => 'option_pmgateway',
                    'desc' => __('Collection ID', 'traveler-billplz'),
                    'condition' => 'pm_gway_st_billplz_enable:is(on)'
                ),
                array(
                    'id' => 'billplz_xsignature_key',
                    'label' => __('X Signature Key', 'traveler-billplz'),
                    'type' => 'text',
                    'section' => 'option_pmgateway',
                    'std' => 'on',
                    'desc' => __('X Signature Key', 'traveler-billplz'),
                    'condition' => 'pm_gway_st_billplz_enable:is(on)'
                ),
                array(
                    'id' => 'billplz_notification',
                    'label' => __('Bill Notification', 'traveler-billplz'),
                    'type' => 'select',
                    'section' => 'option_pmgateway',
                    'choices' => [
                        [
                            'label' => __('No Notification (Recommended)', 'traveler-billplz'),
                            'value' => 0
                        ],
                        [
                            'label' => __('Email Only (FREE)', 'traveler-billplz'),
                            'value' => 1
                        ],
                        [
                            'label' => __('SMS Only (RM0.15)', 'traveler-billplz'),
                            'value' => 2
                        ],
                        [
                            'label' => __('Both (RM0.15)', 'traveler-billplz'),
                            'value' => 3
                        ],
                    ],
                    'std' => 0,
                    'desc' => __('Bill Notification', 'traveler-billplz'),
                    'condition' => 'pm_gway_st_billplz_enable:is(on)'
                ),
            );
        }

        function _pre_checkout_validate()
        {
            if (TravelHelper::get_current_currency('name') != 'MYR') {
                STTemplate::set_message(__('This currency is not supported for Billplz', 'traveler-billplz'));
                return false;
            }
            $validate = new STValidate();
            $validate->set_rules('st_billplz_card_name', __("Card Name", 'traveler-billplz'), 'required');
            $validate->set_rules('st_billplz_card_number', __("Card Number", 'traveler-billplz'), 'required');
            $validate->set_rules('st_billplz_card_expiry_month', __("Expiry Month", 'traveler-billplz'), 'required');
            $validate->set_rules('st_billplz_card_expiry_year', __("Expiry Year", 'traveler-billplz'), 'required');
            $validate->set_rules('st_billplz_card_code', __("Card Code", 'traveler-billplz'), 'required');

            if (!$validate->run()) {
                STTemplate::set_message($validate->error_string());
                return FALSE;
            }
            return true;
        }

        public function setDefaultValue()
        {
            $this->apiKey = st()->get_option('billplz_api_secret_key');
            $this->collectionId = st()->get_option('billplz_collection_id');
            $this->xsignatureKey = st()->get_option('billplz_xsignature_key');
            $this->notification = st()->get_option('billplz_notification');

        }

        function do_checkout($order_id)
        {
            if (!$this->is_available()) {
                return
                    [
                        'status' => 0,
                        'complete_purchase' => 0,
                        'error_type' => 'card_validate',
                        'error_fields' => '',
                    ];
            }
            $this->setDefaultValue();

            $connect = new BillplzConnect($this->apiKey);
            $connect->detectMode();
            $billplz = new BillplzAPI($connect);
            $order_data = $this->get_order_data($order_id);
            $item_names[] = get_the_title($order_id) . ' x ' . 1;
            $description = sprintf(__('Order %s', 'traveler-billplz'), $order_id) . " - " . implode(', ', $item_names);
            $parameter = array(
                'collection_id' => $this->collectionId,
                'email' => $order_data['email'],
                'mobile' => trim($order_data['phone']),
                'name' => empty($order_data['name']) ? $order_data['email'] : $order_data['name'],
                'amount' => strval($order_data['total'] * 100),
                'callback_url' => $this->get_return_url($order_id),
                'description' => mb_substr($description, 0, 199)
            );

            $optional = array(
                'redirect_url' => $this->get_return_url($order_id),
                'reference_2_label' => 'Order ID',
                'reference_2' => $order_data['id']
            );
            try {
                list($rheader, $rbody) = $billplz->toArray($billplz->createBill($parameter, $optional, $this->notification));
                if ($rheader !== 200) {
                    return array('status' => false, 'message' => 'Error Creating bill for order number #' . $order_data['id'] . print_r($rbody, true), 'complete_purchase' => 0);
                } else {
                    return [
                        'status' => true,
                        'redirect_url' => $rbody['url']
                    ];
                }
            } catch (\Exception $e) {
                return array('status' => false, 'message' => $e->getMessage(), 'complete_purchase' => 0);
            }
        }

        public function package_do_checkout($order_id)
        {
            if (!class_exists('STAdminPackages')) {
                return ['status' => TravelHelper::st_encrypt($order_id . 'st0'), 'message' => __('This function is off', 'traveler-billplz')];
            }
            $validate = new STValidate();
            $validate->set_rules('st_billplz_card_name', __("Card Name", 'traveler-billplz'), 'required');
            $validate->set_rules('st_billplz_card_number', __("Card Number", 'traveler-billplz'), 'required');
            $validate->set_rules('st_billplz_card_expiry_month', __("Expiry Month", 'traveler-billplz'), 'required');
            $validate->set_rules('st_billplz_card_expiry_year', __("Expiry Year", 'traveler-billplz'), 'required');
            $validate->set_rules('st_billplz_card_code', __("Card Code", 'traveler-billplz'), 'required');

            if (!$validate->run()) {
                return [
                    'status' => TravelHelper::st_encrypt($order_id . 'st0'),
                    'message' => $validate->error_string()
                ];
            }

            $this->setDefaultValue();

            $connect = new BillplzConnect($this->apiKey);
            $connect->detectMode();
            $billplz = new BillplzAPI($connect);

            $order = STAdminPackages::get_inst()->get('*', $order_id);

            $total = round((float)$order->package_price, 2);
            $item_names[] = get_the_title($order_id) . ' x ' . 1;
            $description = sprintf(__('Order %s', 'traveler-billplz'), $order_id) . " - " . implode(', ', $item_names);
            $parameter = array(
                'collection_id' => $this->collectionId,
                'email' => STInput::post('st_email'),
                'mobile' => STInput::post('st_phone'),
                'name' => STInput::post('st_first_name') . ' ' . STInput::post('st_last_name'),
                'amount' => strval($total * 100),
                'callback_url' => STAdminPackages::get_inst()->get_return_url($order_id),
                'description' => mb_substr($description, 0, 199)
            );

            $optional = array(
                'redirect_url' => STAdminPackages::get_inst()->get_return_url($order_id),
                'reference_2_label' => __('Member Package', 'traveler-billplz'),
                'reference_2' => $order_id
            );
            try {
                list($rheader, $rbody) = $billplz->toArray($billplz->createBill($parameter, $optional, $this->notification));
                if ($rheader !== 200) {
                    return array('status' => TravelHelper::st_encrypt($order_id . 'st0'), 'message' => 'Error Creating bill for order number #' . $order_id . print_r($rbody, true));
                } else {
                    return [
                        'status' => TravelHelper::st_encrypt($order_id . 'st1'),
                        'redirect_url' => $rbody['url']
                    ];
                }
            } catch (\Exception $e) {
                return array('status' => TravelHelper::st_encrypt($order_id . 'st0'), 'message' => $e->getMessage());
            }
        }

        public function get_order_data($order_id)
        {
            $total = get_post_meta($order_id, 'total_price', true);
            $total = round((float)$total, 2);
            $data = array(
                'first_name' => get_post_meta($order_id, 'st_first_name', true),
                'last_name' => get_post_meta($order_id, 'st_last_name', true),
                'email' => get_post_meta($order_id, 'st_email', true),
                'phone' => get_post_meta($order_id, 'st_phone', true),
                'total' => $total,
                'id' => $order_id,
            );

            $data['name'] = trim($data['first_name'] . ' ' . $data['last_name']);

            return $data;
        }

        function complete_purchase($order_id)
        {
            return true;
        }

        function check_complete_purchase($order_id)
        {
            $this->setDefaultValue();
            try {
                $data = BillplzConnect::getXSignature($this->xsignatureKey);
            } catch (Exception $e) {
                exit('Failed X Signature Validation');
            }

            $connect = new BillplzConnect($this->apiKey);
            $connect->detectMode();
            $billplz = new BillplzAPI($connect);
            try {
                list($rheader, $rbody) = $billplz->toArray($billplz->getBill($data['id']));
                if ($rbody['paid']) {
                    return [
                        'status' => true
                    ];
                } else {
                    return [
                        'status' => false,
                    ];
                }
            } catch (\Exception $e) {
                return [
                    'status' => false,
                    'message' => $e->getMessage()
                ];
            }

        }
        function package_completed_checkout($order_id)
        {
            if (!class_exists('STAdminPackages')) {
                return ['status' => false];
            }
            $this->setDefaultValue();
            try {
                $data = BillplzConnect::getXSignature($this->xsignatureKey);
            } catch (Exception $e) {
                exit('Failed X Signature Validation');
            }
            $connect = new BillplzConnect($this->apiKey);
            $connect->detectMode();
            $billplz = new BillplzAPI($connect);
            try {
                list($rheader, $rbody) = $billplz->toArray($billplz->getBill($data['id']));
                if ($rbody['paid']) {
                    return true;
                } else {
                    return false;
                }
            } catch (\Exception $e) {
                return false;
            }

        }

        function html()
        {
            echo Traveler_Billplz_Payment::get_inst()->loadTemplate('billplz');
        }

        function get_name()
        {
            return __('Billplz', 'traveler-billplz');
        }

        function get_default_status()
        {
            return $this->default_status;
        }

        function is_available($item_id = false)
        {
            if (st()->get_option('pm_gway_st_billplz_enable') == 'off') {
                return false;
            } else {
                if (!st()->get_option('billplz_api_secret_key')) {
                    return false;
                }
            }

            if ($item_id) {
                $meta = get_post_meta($item_id, 'is_meta_payment_gateway_st_billplz', true);
                if ($meta == 'off') {
                    return false;
                }
            }

            return true;
        }

        function getGatewayId()
        {
            return $this->_gateway_id;
        }

        function is_check_complete_required()
        {
            return true;
        }

        function get_logo()
        {
            return Traveler_Billplz_Payment::get_inst()->pluginUrl . 'assets/img/billplz.png';
        }

        static function instance()
        {
            if (!self::$_ints) {
                self::$_ints = new self();
            }

            return self::$_ints;
        }

        static function add_payment($payment)
        {
            $payment['st_billplz'] = self::instance();

            return $payment;
        }
    }

    add_filter('st_payment_gateways', array('ST_Billplz_Payment_Gateway', 'add_payment'));
}