<?php

/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 15-10-2018
 * Time: 10:19 AM
 * Since: 1.0.0
 * Updated: 1.0.0
 */

if (!class_exists('ST_Ipay88_Payment_Gateway')) {

    class ST_Ipay88_Payment_Gateway extends STAbstactPaymentGateway

    {

        private $default_status = true;

        private $_gateway_id = 'st_ipay88';


        protected $gateway;

        protected $sandbox;

        protected $url;

        protected $merchantCode;

        protected $merchantKey;

        protected $hash_amount;

        protected $formatted_amount;


        public $types_mapping;

        public $types_mapping_ph;

        public $types_mapping_in;


        public function __construct()

        {

            add_filter('st_payment_gateway_st_ipay88_name', [$this, 'get_name']);


            $this->types_mapping = array(

                'image' => array(

                    '2' => 'credit-card',

                    '6' => 'maybank2u',

                    '8' => 'allianceonline',

                    '10' => 'ambank',

                    '14' => 'rhb	',

                    '15' => 'hongleong',

                    '20' => 'cimb',

                    '22' => 'webcash',

                    '31' => 'publicbank',

                    '48' => 'paypal',

                    '100' => 'celcomaircash',

                    '102' => 'bankrakyat',

                    '103' => 'affinbank',

                    '124' => 'bsn',

                    '134' => 'bankislam',

                    '152' => 'uobbankmy',

                ),

                'id' => array(

                    '2' => '_credit_card',

                    '6' => '_maybank2u',

                    '8' => '_alliance_online',

                    '10' => '_ambank',

                    '14' => '_rhb',

                    '15' => '_hong_leong_online',

                    '20' => '_cimb_click',

                    '22' => '_web_cash',

                    '31' => '_publicbank',

                    '48' => '_paypal',

                    '100' => '_celcomaircash',

                    '102' => '_bankrakyat',

                    '103' => '_affinbank',

                    '124' => '_bsn',

                    '134' => '_bankislam',

                    '152' => '_uobbankmy',

                )

            );


            $this->types_mapping_ph = array(

                'image' => array(

                    '1' => 'credit-card',

                    '5' => 'bancnet',

                    '6' => 'paypal',

                ),

                'id' => array(

                    '1' => '_credit_card',

                    '5' => '_bancnet',

                    '6' => '_paypal',


                )

            );

            $this->types_mapping_in = array(

                'image' => array(

                    '1' => 'credit-card',

                ),

                'id' => array(

                    '1' => '_credit_card',

                )

            );


            add_action('init', [$this, 'backendResponsive']);

        }


        public function setDefaultParameters()

        {

            $this->gateway = st()->get_option('gateway_ipay88');

            $this->merchantCode = st()->get_option('merchant_code_ipay88');

            $this->merchantKey = st()->get_option('merchant_key_ipay88');

            $this->sandbox = st()->get_option('test_mode_ipay88', 'on');

            if ('PH' == $this->gateway) {

                if ('on' == $this->sandbox) {

                    $this->url = 'https://sandbox.ipay88.com.ph/epayment/entry.asp';

                } else {

                    $this->url = 'https://payment.ipay88.com.ph/epayment/entry.asp';

                }

            } elseif ('IN' == $this->gateway) {

                if ('on' == $this->sandbox) {

                    $this->url = 'https://sandbox.ipay88.co.id/epayment/entry.asp';

                } else {

                    $this->url = 'https://payment.ipay88.co.id/epayment/entry.asp';

                }

            } else {

                $this->url = 'https://www.mobile88.com/epayment/entry.asp';

            }

        }


        function get_default_status()

        {

            return $this->default_status;

        }


        function get_name()

        {

            return __('Ipay88', 'traveler-ipay88');

        }


        function _pre_checkout_validate()

        {

            return true;

        }


        function get_option_fields()

        {

            return [

                [

                    'id' => 'gateway_ipay88',

                    'label' => esc_html__('Gateway', 'traveler-ipay88'),

                    'type' => 'select',

                    'choices' => [

                        [

                            'label' => esc_html__('Malaysia', 'traveler-ipay88'),

                            'value' => 'MY'

                        ],

                        [

                            'label' => esc_html__('Philippines', 'traveler-ipay88'),

                            'value' => 'PH'

                        ],

                        [

                            'label' => esc_html__('Indonesia', 'traveler-ipay88'),

                            'value' => 'IN'

                        ],

                    ],

                    'desc' => esc_html__('Which iPay88 gateway are you using? Currently supported are Malaysia and Philippines.', 'traveler-ipay88'),

                    'section' => 'option_pmgateway',

                ],

                [

                    'id' => 'test_mode_ipay88',

                    'label' => esc_html__('Test Mode', 'traveler-ipay88'),

                    'type' => 'on-off',

                    'std' => 'on',

                    'desc' => esc_html__('Sandbox mode provides you with a chance to test your gateway integration with iPay88. The payment requests will be send to the iPay88 sandbox URL. Disable to start accepting Live payments.', 'traveler-ipay88'),

                    'section' => 'option_pmgateway'

                ],

                [

                    'id' => 'merchant_code_ipay88',

                    'label' => esc_html__('Merchant ID', 'traveler-ipay88'),

                    'type' => 'text',

                    'section' => 'option_pmgateway'

                ],

                [

                    'id' => 'merchant_key_ipay88',

                    'label' => esc_html__('Merchant Key', 'traveler-ipay88'),

                    'type' => 'text',

                    'section' => 'option_pmgateway'

                ],

                [

                    'id' => 'paymenttype_available_ipay88',

                    'label' => esc_html__('Payment Available (MALAYSIA)', 'traveler-ipay88'),

                    'type' => 'checkbox',

                    'choices' => [

                        [

                            'label' => esc_html__('Credit Card', 'traveler-ipay88'),

                            'value' => 2

                        ],

                        [

                            'label' => esc_html__('Maybank2U', 'traveler-ipay88'),

                            'value' => 6

                        ],

                        [

                            'label' => esc_html__('Alliance Online', 'traveler-ipay88'),

                            'value' => 8

                        ],

                        [

                            'label' => esc_html__('AmBank', 'traveler-ipay88'),

                            'value' => 10

                        ],

                        [

                            'label' => esc_html__('RHB', 'traveler-ipay88'),

                            'value' => 14

                        ],

                        [

                            'label' => esc_html__('Hong Leong Online', 'traveler-ipay88'),

                            'value' => 15

                        ],

                        [

                            'label' => esc_html__('CIMB Click', 'traveler-ipay88'),

                            'value' => 20

                        ],

                        [

                            'label' => esc_html__('Web Cash', 'traveler-ipay88'),

                            'value' => 22

                        ],

                        [

                            'label' => esc_html__('Public Bank Online', 'traveler-ipay88'),

                            'value' => 31

                        ],

                        [

                            'label' => esc_html__('PayPal', 'traveler-ipay88'),

                            'value' => 48

                        ],

                        [

                            'label' => esc_html__('Celcom AirCash', 'traveler-ipay88'),

                            'value' => 100

                        ],

                        [

                            'label' => esc_html__('Bank Rakyat', 'traveler-ipay88'),

                            'value' => 102

                        ],

                        [

                            'label' => esc_html__('AffinBank', 'traveler-ipay88'),

                            'value' => 103

                        ],

                        [

                            'label' => esc_html__('BSN Online', 'traveler-ipay88'),

                            'value' => 124

                        ],

                        [

                            'label' => esc_html__('BankIslam Online', 'traveler-ipay88'),

                            'value' => 134

                        ],

                        [

                            'label' => esc_html__('UOB Bank Online', 'traveler-ipay88'),

                            'value' => 152

                        ],

                    ],

                    'condition' => 'gateway_ipay88:is(MY)',

                    'section' => 'option_pmgateway'

                ],

                [

                    'id' => 'paymenttype_available_ph_ipay88',

                    'label' => esc_html__('Payments Available (PHILIPPINES)', 'traveler-ipay88'),

                    'type' => 'checkbox',

                    'choices' => [

                        [

                            'label' => esc_html__('Credit Card', 'traveler-ipay88'),

                            'value' => 1

                        ],

                        [

                            'label' => esc_html__('BancNet', 'traveler-ipay88'),

                            'value' => 5

                        ],

                        [

                            'label' => esc_html__('PayPal', 'traveler-ipay88'),

                            'value' => 6

                        ],

                    ],

                    'condition' => 'gateway_ipay88:is(PH)',

                    'section' => 'option_pmgateway'

                ],

                [

                    'id' => 'paymenttype_available_in_ipay88',

                    'label' => esc_html__('Payments Available (INDONESIA)', 'traveler-ipay88'),

                    'type' => 'checkbox',

                    'choices' => [

                        [

                            'label' => esc_html__('Credit Card', 'traveler-ipay88'),

                            'value' => 1

                        ],

                    ],

                    'condition' => 'gateway_ipay88:is(IN)',

                    'section' => 'option_pmgateway'

                ],

                [

                    'id' => 'ipay88_des',

                    'label' => esc_html__('Description', 'traveler-ipay88'),

                    'type' => 'textarea-simple',

                    'rows' => 5,

                    'desc' => esc_html__('Enter some details for this payment', 'traveler-ipay88'),

                    'section' => 'option_pmgateway'

                ],

            ];

        }


        function do_checkout($order_id)

        {

            $payment = STInput::post('st_payment_gateway');

            $paymentType = STInput::post('paymentcode');

            if ($payment != 'st_ipay88' || ($payment == 'st_ipay88' && !$paymentType)) {

                return [

                    'status' => false,

                    'message' => __('Can not create payment URL.', 'traveler-ipay88')

                ];

            }


            $this->setDefaultParameters();


            $params = $this->get_purchase_data($order_id);

            $ipay88_form_array = array();

            foreach ($params as $key => $value) {

                $ipay88_form_array[] = '<input type="hidden" name="' . esc_attr($key) . '" value="' . esc_attr($value) . '" />';

            }

            $form = sprintf('<h4>Redirecting....</h4>

             <form action="%s" method="post" id="st_form_ipay88_submit">%s</form>

    						<script>document.getElementById(\'st_form_ipay88_submit\').submit();</script>', $this->url, implode('', $ipay88_form_array));

            return [

                'status' => true,

                'redirect_form' => $form

            ];


        }


        function package_do_checkout($order_id)
        {
            if (!class_exists('STAdminPackages')) {

                return ['status' => TravelHelper::st_encrypt($order_id . 'st0'), 'message' => __('This function is off', 'traveler-ipay88')];
            }

            $payment = STInput::post('st_payment_gateway');

            $paymentType = STInput::post('paymentcode');

            if ($payment != 'st_ipay88' || ($payment == 'st_ipay88' && !$paymentType)) {
                return [
                    'status' => TravelHelper::st_encrypt($order_id . 'st0'),
                    'message' => __('Can not create payment.', 'traveler-ipay88')
                ];

            }

            $this->setDefaultParameters();
            $order = STAdminPackages::get_inst()->get('*', $order_id);
            $currency = TravelHelper::get_current_currency('name');
            $total = round((float)$order->package_price, 2);
            $amount = number_format((float)$total, 2, '.', '');
            $format_amt = $this->formatAmount($amount);
            $first_name = STInput::post('st_first_name');
            $last_name = STInput::post('st_last_name');
            $email_address = STInput::post('st_email');
            $phone = STInput::post('st_phone');

            $params = array(
                'MerchantCode' => $this->merchantCode,
                'RefNo' => $order_id,
                'Amount' => $amount,
                'Currency' => $currency,
                'ProdDesc' => __('Member Package', 'traveler-ipay88'),
                'UserName' => $first_name . ' ' . $last_name,
                'UserEmail' => $email_address,
                'UserContact' => $phone,
                'ResponseURL' => STAdminPackages::get_inst()->get_return_url($order_id),
                'BackendURL' => STAdminPackages::get_inst()->get_return_url($order_id, true),
            );

            $payment_type = STInput::post('paymentcode');
            $payment_type = str_replace('ipay88-', '', $payment_type);

            if (null != $payment_type && 0 != $payment_type) {

                $params['PaymentId'] = $payment_type;
            }

            $the_string = $this->merchantKey . $this->merchantCode . $order_id . $format_amt . $currency;

            $params['Signature'] = $this->generate_sha1_signature($the_string);

            $ipay88_form_array = array();

            foreach ($params as $key => $value) {

                $ipay88_form_array[] = '<input type="hidden" name="' . esc_attr($key) . '" value="' . esc_attr($value) . '" />';

            }
            $form = sprintf('<h4>Redirecting....</h4>

             <form action="%s" method="post" id="st_form_ipay88_submit">%s</form>

    						<script>document.getElementById(\'st_form_ipay88_submit\').submit();</script>', $this->url, implode('', $ipay88_form_array));

            return [
                'status' => TravelHelper::st_encrypt($order_id . 'st1'),
                'redirect_form' => $form
            ];

        }


        private function get_purchase_data($new_order)

        {
            $total = get_post_meta($new_order, 'total_price', true);

            $total = round((float)$total, 2);

            $amount = number_format((float)$total, 2, '.', '');
            $format_amt = $this->formatAmount($amount);
            $service_id = (int)get_post_meta($new_order, 'item_id', true);
            $first_name = get_post_meta($new_order, 'st_first_name', true);
            $last_name = get_post_meta($new_order, 'st_last_name', true);
            $email_address = get_post_meta($new_order, 'st_email', true);
            $phone = get_post_meta($new_order, 'st_phone', true);
            $currency = TravelHelper::get_current_currency('name');

            $params = array(
                'MerchantCode' => $this->merchantCode,
                'RefNo' => $new_order,
                'Amount' => $amount,
                'Currency' => $currency,
                'ProdDesc' => get_the_title($service_id),
                'UserName' => $first_name . ' ' . $last_name,
                'UserEmail' => $email_address,
                'UserContact' => $phone,
                'ResponseURL' => $this->get_return_url($new_order),
                'BackendURL' => $this->get_return_url($new_order, true),

            );;

            $payment_type = STInput::post('paymentcode');

            $payment_type = str_replace('ipay88-', '', $payment_type);

            if (null != $payment_type && 0 != $payment_type) {

                $params['PaymentId'] = $payment_type;

            }
            $the_string = $this->merchantKey . $this->merchantCode . $new_order . $format_amt . $currency;

            $params['Signature'] = $this->generate_sha1_signature($the_string);

            return $params;

        }

        public function formatAmount($amt)
        {
            $remove_dot = str_replace('.', '', $amt);
            $remove_comma = str_replace(',', '', $remove_dot);
            return $remove_comma;
        }


        public function hex2bin($hexSource)

        {
            $bin = '';
            for ($i = 0; $i < strlen($hexSource); $i = $i + 2) {

                $bin .= chr(hexdec(substr($hexSource, $i, 2)));
            }

            return $bin;
        }

        private function generate_sha1_signature($params)

        {
            return base64_encode(hex2bin(sha1($params)));
        }


        function complete_purchase($order_id)

        {
            return true;
        }


        function check_complete_purchase($order_id)

        {
            $this->setDefaultParameters();

            if ($this->validate_response()) {
                return ['status' => true];
            } else {
                return ['status' => false];
            }
        }


        function package_completed_checkout($order_id)

        {
            if (!class_exists('STAdminPackages')) {

                return ['status' => false];
            }

            $this->setDefaultParameters();

            if ($this->validate_response()) {
                return true;
            } else {
                return false;
            }
        }


        public function backendResponsive()

        {

            if (isset($_GET['backendResponsive']) && $_GET['backendResponsive'] == 'ipay88' && isset($_GET['orderID'])) {

                $this->setDefaultParameters();

                if ($this->validate_response()) {

                    update_post_meta($_GET['orderID'], 'status', 'complete');

                    STCart::send_mail_after_booking($_GET['orderID'], true);

                    do_action('st_booking_change_status', 'complete', $_GET['orderID'], 'st_ipay88');
                    return true;
                } else {
                    return false;
                }

            }
        }

        public function package_backendResponsive()

        {
            if (isset($_GET['package_backendResponsive']) && $_GET['package_backendResponsive'] == 'ipay88' && isset($_GET['orderID'])) {

                $this->setDefaultParameters();

                if ($this->validate_response()) {

                    STAdminPackages::get_inst()->update_status('completed', $_GET['orderID']);
                    return true;

                } else {
                    return false;
                }
            }
        }


        public function validate_response()

        {
            $mcode = $_POST['MerchantCode'];
            $payid = $_POST['PaymentId'];
            $refno = $_POST['RefNo'];
            $amt_txt = $_POST['Amount'];
            $cur = $_POST['Currency'];
            $ret_sign = $_POST['Signature'];
            $status = $_POST['Status'];

            $amnt = str_replace(',', '', $amt_txt);
            $amnt_final = str_replace('.', '', $amnt);
            $combined = $this->merchantKey . $this->merchantCode . $payid . $refno . $amnt_final . $cur . $status;
            $signed = $this->generate_sha1_signature($combined);
            if ($status == 1)
                if ($ret_sign == $signed) {
                    return true;
                } else {
                    return false;
                }
            elseif ($status != 1 && $signed == $ret_sign) {
                return false;
            }

        }


        function is_available($item_id = false)
        {
            if (st()->get_option('pm_gway_st_ipay88_enable') == 'off') {
                return false;
            }
            return true;

        }

        function getGatewayId()

        {
            return $this->_gateway_id;
        }

        function is_check_complete_required()

        {
            return true;
        }


        function get_logo()

        {
            return Traveler_Ipay88_Payment::get_inst()->pluginUrl . 'assets/img/ipay88.png';
        }


        function html()

        {
            echo Traveler_Ipay88_Payment::get_inst()->loadTemplate('ipay');
        }

        function get_return_url($order_id, $backend = false)

        {
            $order_token_code = get_post_meta($order_id, 'order_token_code', TRUE);

            if (!$order_token_code) {

                $array = [

                    'gateway_name' => $this->getGatewayId(),

                    'order_code' => $order_id,

                    'status' => TRUE

                ];

            } else {

                $array = [

                    'gateway_name' => $this->getGatewayId(),

                    'order_token_code' => $order_token_code,

                    'status' => TRUE

                ];

            }

            if ($backend) {

                $array['backendResponsive'] = 'ipay88';

                $array['orderID'] = $order_id;

            }

            return add_query_arg($array, STCart::get_success_link());

        }


        public static function get_inst()

        {
            static $instance;

            if (is_null($instance)) {

                $instance = new self();
            }

            return $instance;
        }

        public static function add_payment($payment)

        {
            $payment['st_ipay88'] = self::get_inst();

            return $payment;
        }
    }


    add_filter('st_payment_gateways', ['ST_Ipay88_Payment_Gateway', 'add_payment']);

}