<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 15-10-2018
 * Time: 10:19 AM
 * Since: 1.0.0
 * Updated: 1.0.0
 */
if (!class_exists('ST_Mercadopago_Payment_Gateway')) {
    class ST_Mercadopago_Payment_Gateway extends STAbstactPaymentGateway
    {
        private $default_status = true;
        private $_gateway_id = 'st_mercadopago';
        private $client_id;
        private $client_secret;
        private $gateway;

        public function __construct()
        {
            add_filter('st_payment_gateway_st_mercadopago_name', [$this, 'get_name']);


            add_action('init', [$this, 'backendResponsive']);
        }

        public function setDefaultParameters()
        {
            $this->client_id = st()->get_option('mercadopago_client_id', '');
            $this->client_secret = st()->get_option('mercadopago_client_secret');
            $this->gateway = new MP ($this->client_id, $this->client_secret);
            if (st()->get_option('mercadopago_test_mode', 'on') == 'on') {
                $this->gateway->sandbox_mode(true);
            }
        }

        function get_default_status()
        {
            return $this->default_status;
        }

        function get_name()
        {
            return __('Mercado Pago', 'traveler-mercadopago');
        }

        function _pre_checkout_validate()
        {
            return true;
        }

        function get_option_fields()
        {
            return [
                [
                    'id' => 'mercadopago_test_mode',
                    'label' => esc_html__('Test Mode', 'traveler-mercadopago'),
                    'type' => 'on-off',
                    'std' => 'on',
                    'section' => 'option_pmgateway'
                ],
                [
                    'id' => 'mercadopago_client_id',
                    'label' => __('Client ID', 'traveler-mercadopago'),
                    'type' => 'text',
                    'section' => 'option_pmgateway'
                ],
                [
                    'id' => 'mercadopago_client_secret',
                    'label' => __('Client Secret', 'traveler-mercadopago'),
                    'type' => 'text',
                    'section' => 'option_pmgateway'
                ],

            ];
        }

        function do_checkout($order_id)
        {
            $this->setDefaultParameters();
            $purchase = $this->get_purchase_data($order_id);

            try {
                $respon = $this->gateway->create_preference($purchase);
                if ($this->is_redirect($respon)) {
                    return [
                        'status' => true,
                        'redirect' => $this->get_redirect_url($respon)
                    ];
                } else {
                    return [
                        'status' => false,
                        'message' => esc_html__('Your order has been created but we can not process', 'traveler-mercadopago'),
                    ];
                }
            } catch (\Exception $e) {
                return [
                    'status' => false,
                    'message' => sprintf(esc_html__('Your order has been created but we can not process. Error code: %s', 'traveler-mercadopago'), $e->getMessage())
                ];
            }
        }

        function package_do_checkout($order_id)
        {
            if (!class_exists('STAdminPackages')) {
                return ['status' => TravelHelper::st_encrypt($order_id . 'st0'), 'message' => __('This function is off', 'traveler-mercadopago')];
            }
            $this->setDefaultParameters();

            $order = STAdminPackages::get_inst()->get('*', $order_id);
            $total = round((float)$order->package_price, 2);

            $first_name = STInput::post( 'st_first_name', '');
            $last_name = STInput::post( 'st_last_name', '');
            $email_address = STInput::post( 'st_email', '');
            $phone = STInput::post( 'st_phone', '');
            $address = STInput::post( 'st_address', 'Address');
            $zipcode = STInput::post( 'st_zip_code', '10000');
            $purchase = [
                'items' => [
                    [
                        'id' => $order_id,
                        'title' => __('Member Package', 'traveler-mercadopago'),
                        'quantity' => 1,
                        'unit_price' => $total,
                        'currency_id' => TravelHelper::get_current_currency('name'),
                        'category_id' => 'travels',
                        'picture_url' => 'https://www.mercadopago.com/org-img/MP3/home/logomp3.gif',
                        'description' =>  __('Member Package', 'traveler-mercadopago')
                    ]
                ],
                'payer' => [
                    'name' => $first_name . ' ' . $last_name,
                    'email' => $email_address,
                    'phone' => [
                        'number' => $phone
                    ],
                    'address' => [
                        'street_name' => $address,
                        'zip_code' => $zipcode
                    ]
                ],
                'back_urls' => [
                    'success' => STAdminPackages::get_inst()->get_return_url($order_id),
                    'failure' => STAdminPackages::get_inst()->get_return_url($order_id),
                    'pending' => STAdminPackages::get_inst()->get_return_url($order_id)
                ],
                'auto_return' => 'approved',
                'notification_url' => STAdminPackages::get_inst()->get_return_url($order_id),
                'external_reference' => 'Reference_' . $order_id,
            ];

            try {
                $respon = $this->gateway->create_preference($purchase);
                if ($this->is_redirect($respon)) {
                    return [
                        'status' => TravelHelper::st_encrypt( $order_id . 'st1' ),
                        'redirect_url' => $this->get_redirect_url($respon)
                    ];
                } else {
                    return [
                        'status' => TravelHelper::st_encrypt( $order_id . 'st0' ),
                        'message' => esc_html__('Your order has been created but we can not process', 'traveler-mercadopago'),
                    ];
                }
            } catch (\Exception $e) {
                return [
                    'status' => TravelHelper::st_encrypt( $order_id . 'st0' ),
                    'message' => sprintf(esc_html__('Your order has been created but we can not process. Error code: %s', 'traveler-mercadopago'), $e->getMessage())
                ];
            }

        }

        private function get_redirect_url($respon = [])
        {
            if ($this->is_redirect($respon)) {
                if (st()->get_option('mercadopago_test_mode', 'on') == 'on') {
                    return esc_url($respon['response']['sandbox_init_point']);
                } else {
                    return esc_url($respon['response']['init_point']);
                }
            }

            return null;
        }

        private function is_redirect($respon = [])
        {
            if (isset($respon['status']) && in_array($respon['status'], ['200', '201'])) {
                return true;
            }

            return false;
        }

        private function get_purchase_data($new_order)
        {
            $total = get_post_meta($new_order, 'total_price', true);
            $total = round((float)$total, 2);

            $service_id = (int)get_post_meta($new_order, 'item_id', true);

            $first_name = get_post_meta($new_order, 'st_first_name', true);
            $last_name = get_post_meta($new_order, 'st_last_name', true);
            $email_address = get_post_meta($new_order, 'st_email', true);
            $phone = get_post_meta($new_order, 'st_phone', true);
            $address = get_post_meta($new_order, 'st_address', true);
            $zipcode = get_post_meta($new_order, 'st_zip_code', true);
            $purchase = [
                'items' => [
                    [
                        'id' => $service_id,
                        'title' => get_the_title($service_id),
                        'quantity' => 1,
                        'unit_price' => $total,
                        'currency_id' => TravelHelper::get_current_currency('name'),
                        'category_id' => 'travels',
                        'picture_url' => 'https://www.mercadopago.com/org-img/MP3/home/logomp3.gif',
                        'description' => get_the_title($service_id)
                    ]
                ],
                'payer' => [
                    'name' => $first_name . ' ' . $last_name,
                    'email' => $email_address,
                    'phone' => [
                        'number' => $phone
                    ],
                    'address' => [
                        'street_name' => $address,
                        'zip_code' => $zipcode
                    ]
                ],
                'back_urls' => [
                    'success' => $this->get_return_url($new_order),
                    'failure' => $this->get_return_url($new_order),
                    'pending' => $this->get_return_url($new_order)
                ],
                'auto_return' => 'approved',
                'notification_url' => $this->get_return_url($new_order),
                'external_reference' => 'Reference_' . $service_id,
            ];

            return $purchase;

        }

        function complete_purchase($order_id)
        {
            return true;
        }
        function package_completed_checkout($order_id)
        {
            if (!class_exists('STAdminPackages')) {
                return ['status' => false];
            }
            $this->setDefaultParameters();
            $data = $_GET;

            if (isset($data['id']) && isset($data['topic'])) {
                $access_token = array('access_token' => $this->gateway->get_access_token());
                if ($data['topic'] == 'merchant_order') {
                    $ipn_info = $this->gateway->get('/merchant_orders/' . $data['id'], $access_token, false);
                    $status = 'pending';
                    if (!is_wp_error($ipn_info) && ($ipn_info['status'] == 200 || $ipn_info['status'] == 201)) {
                        $payments = $ipn_info['response']['payments'];
                        if (sizeof($payments) >= 1) {
                            $ipn_info['response']['ipn_type'] = 'merchant_order';
                            $order_key = $data['external_reference'];
                            if (empty($order_key)) {
                                $status = 'pending';
                            }
                            $invoice_prefix = get_option('_mp_store_identificator', 'WC-');
                            $id = (int)str_replace($invoice_prefix, '', $order_key);
                            $order = wc_get_order($id);
                            if (!$order) {
                                $status = 'pending';
                            }
                            if ($order_id !== $id) {
                                $status = 'pending';
                            }
                            $payments = $data['payments'];
                            if (sizeof($payments) == 1) {
                                $status = $payments[0]['status'];
                            } elseif (sizeof($payments) > 1) {
                                $total_paid = 0.00;
                                $total_refund = 0.00;
                                $total = $data['shipping_cost'] + $data['total_amount'];
                                foreach ($data['payments'] as $payment) {
                                    if ($payment['status'] === 'approved') {
                                        $total_paid += (float)$payment['total_paid_amount'];
                                    } elseif ($payment['status'] === 'refunded') {
                                        $total_refund += (float)$payment['amount_refunded'];
                                    }
                                }
                                if ($total_paid >= $total) {
                                    $status = 'complete';
                                } elseif ($total_refund >= $total) {
                                    $status = 'pending';
                                } else {
                                    $status = 'pending';
                                }
                            }
                        } else {
                            $status = 'pending';
                        }
                    } else {
                        $status = 'pending';
                    }
                    if ($status == 'complete') {
                        return true;
                    } else {
                        return false;
                    }
                } elseif ($data['topic'] == 'payment') {
                    $payment_info = $this->gateway->get('/v1/payments/' . $data['id'], $access_token, false);
                    if (!is_wp_error($payment_info) && ($payment_info['status'] == 200 || $payment_info['status'] == 201)) {
                        $status = 'pending';

                        $payments = $payment_info['response']['payments'];
                        if (sizeof($payments) >= 1) {
                            $ipn_info['response']['ipn_type'] = 'merchant_order';
                            $order_key = $data['external_reference'];
                            if (empty($order_key)) {
                                $status = 'pending';
                            }
                            $invoice_prefix = get_option('_mp_store_identificator', 'WC-');
                            $id = (int)str_replace($invoice_prefix, '', $order_key);
                            $order = wc_get_order($id);
                            if (!$order) {
                                $status = 'pending';
                            }
                            if ($order_id !== $id) {
                                $status = 'pending';
                            }
                            $payments = $data['payments'];
                            if (sizeof($payments) == 1) {
                                $status = $payments[0]['status'];
                            } elseif (sizeof($payments) > 1) {
                                $total_paid = 0.00;
                                $total_refund = 0.00;
                                $total = $data['shipping_cost'] + $data['total_amount'];
                                foreach ($data['payments'] as $payment) {
                                    if ($payment['status'] === 'approved') {
                                        $total_paid += (float)$payment['total_paid_amount'];
                                    } elseif ($payment['status'] === 'refunded') {
                                        $total_refund += (float)$payment['amount_refunded'];
                                    }
                                }
                                if ($total_paid >= $total) {
                                    $status = 'complete';
                                } elseif ($total_refund >= $total) {
                                    $status = 'pending';
                                } else {
                                    $status = 'pending';
                                }
                            }
                        } else {
                            $status = 'pending';
                        }
                    } else {
                        $status = 'pending';
                    }
                    if ($status == 'complete') {
                        return  true;
                    } else {
                        return false;
                    }
                } else {
                    return true;
                }
            }
        }

        function check_complete_purchase($order_id)
        {
            $this->setDefaultParameters();
            $data = $_GET;
            if (isset($data['id']) && isset($data['topic'])) {
                $access_token = array('access_token' => $this->gateway->get_access_token());
                if ($data['topic'] == 'merchant_order') {
                    $ipn_info = $this->gateway->get('/merchant_orders/' . $data['id'], $access_token, false);
                    $status = 'pending';
                    if (!is_wp_error($ipn_info) && ($ipn_info['status'] == 200 || $ipn_info['status'] == 201)) {
                        $payments = $ipn_info['response']['payments'];
                        if (sizeof($payments) >= 1) {
                            $ipn_info['response']['ipn_type'] = 'merchant_order';
                            $order_key = $data['external_reference'];
                            if (empty($order_key)) {
                                $status = 'pending';
                            }
                            $invoice_prefix = get_option('_mp_store_identificator', 'WC-');
                            $id = (int)str_replace($invoice_prefix, '', $order_key);
                            $order = wc_get_order($id);
                            if (!$order) {
                                $status = 'pending';
                            }
                            if ($order_id !== $id) {
                                $status = 'pending';
                            }
                            $payments = $data['payments'];
                            if (sizeof($payments) == 1) {
                                $status = $payments[0]['status'];
                            } elseif (sizeof($payments) > 1) {
                                $total_paid = 0.00;
                                $total_refund = 0.00;
                                $total = $data['shipping_cost'] + $data['total_amount'];
                                foreach ($data['payments'] as $payment) {
                                    if ($payment['status'] === 'approved') {
                                        $total_paid += (float)$payment['total_paid_amount'];
                                    } elseif ($payment['status'] === 'refunded') {
                                        $total_refund += (float)$payment['amount_refunded'];
                                    }
                                }
                                if ($total_paid >= $total) {
                                    $status = 'complete';
                                } elseif ($total_refund >= $total) {
                                    $status = 'pending';
                                } else {
                                    $status = 'pending';
                                }
                            }
                        } else {
                            $status = 'pending';
                        }
                    } else {
                        $status = 'pending';
                    }
                    if ($status == 'complete') {
                        return [
                            'status' => true
                        ];
                    } else {
                        return [
                            'status' => false
                        ];
                    }
                } elseif ($data['topic'] == 'payment') {
                    $payment_info = $this->gateway->get('/v1/payments/' . $data['id'], $access_token, false);
                    if (!is_wp_error($payment_info) && ($payment_info['status'] == 200 || $payment_info['status'] == 201)) {
                        $status = 'pending';

                        $payments = $payment_info['response']['payments'];
                        if (sizeof($payments) >= 1) {
                            $ipn_info['response']['ipn_type'] = 'merchant_order';
                            $order_key = $data['external_reference'];
                            if (empty($order_key)) {
                                $status = 'pending';
                            }
                            $invoice_prefix = get_option('_mp_store_identificator', 'WC-');
                            $id = (int)str_replace($invoice_prefix, '', $order_key);
                            $order = wc_get_order($id);
                            if (!$order) {
                                $status = 'pending';
                            }
                            if ($order_id !== $id) {
                                $status = 'pending';
                            }
                            $payments = $data['payments'];
                            if (sizeof($payments) == 1) {
                                $status = $payments[0]['status'];
                            } elseif (sizeof($payments) > 1) {
                                $total_paid = 0.00;
                                $total_refund = 0.00;
                                $total = $data['shipping_cost'] + $data['total_amount'];
                                foreach ($data['payments'] as $payment) {
                                    if ($payment['status'] === 'approved') {
                                        $total_paid += (float)$payment['total_paid_amount'];
                                    } elseif ($payment['status'] === 'refunded') {
                                        $total_refund += (float)$payment['amount_refunded'];
                                    }
                                }
                                if ($total_paid >= $total) {
                                    $status = 'complete';
                                } elseif ($total_refund >= $total) {
                                    $status = 'pending';
                                } else {
                                    $status = 'pending';
                                }
                            }
                        } else {
                            $status = 'pending';
                        }
                    } else {
                        $status = 'pending';
                    }
                    if ($status == 'complete') {
                        return [
                            'status' => true
                        ];
                    } else {
                        return [
                            'status' => false
                        ];
                    }
                } else {
                    return [
                        'status' => false,
                        'message' => __('Request failure, received an unhandled topic.', 'traveler-mercadopago')
                    ];
                }
            }
        }


        function is_available($item_id = false)
        {
            if (st()->get_option('pm_gway_st_mercadopago_enable') == 'off') {
                return false;
            }

            return true;
        }

        function getGatewayId()
        {
            return $this->_gateway_id;
        }

        function is_check_complete_required()
        {
            return true;
        }

        function get_logo()
        {
            return Traveler_Mercadopago_Payment::get_inst()->pluginUrl . 'assets/img/mercadopago.png';
        }

        function html()
        {
            echo Traveler_Mercadopago_Payment::get_inst()->loadTemplate('mercadopago');
        }

        function get_return_url($order_id)
        {
            $order_token_code = get_post_meta($order_id, 'order_token_code', TRUE);
            if (!$order_token_code) {
                $array = [
                    'gateway_name' => $this->getGatewayId(),
                    'order_code' => $order_id,
                    'status' => TRUE
                ];
            } else {
                $array = [
                    'gateway_name' => $this->getGatewayId(),
                    'order_token_code' => $order_token_code,
                    'status' => TRUE
                ];

            }

            return add_query_arg($array, STCart::get_success_link());

        }

        public static function get_inst()
        {
            static $instance;
            if (is_null($instance)) {
                $instance = new self();
            }

            return $instance;
        }

        public static function add_payment($payment)
        {
            $payment['st_mercadopago'] = self::get_inst();

            return $payment;
        }
    }

    add_filter('st_payment_gateways', ['ST_Mercadopago_Payment_Gateway', 'add_payment']);
}