<?php
/**
 * Created by PhpStorm.
 * User: Dungdt
 * Date: 12/15/2015
 * Time: 3:19 PM
 */


if (!class_exists('ST_PayuLatam_Payment_Gateway')) {
    class ST_PayuLatam_Payment_Gateway extends STAbstactPaymentGateway
    {
        static private $_ints;
        private $default_status = true;
        private $_gatewayObject = null;
        private $_gateway_id = 'st_payulatam';

        function __construct()
        {
            add_filter('st_payment_gateway_st_payulatam_name', array($this, 'get_name'));

        }

        function get_option_fields()
        {
            return array(
                [
                    'id' => 'test_mode_payulatam',
                    'label' => esc_html__('Test Mode', 'traveler-payulatam'),
                    'type' => 'on-off',
                    'std' => 'on',
                    'desc' => esc_html__('Using for Payulatam sanbox account', 'traveler-payulatam'),
                    'section' => 'option_pmgateway'
                ],
                [
                    'id' => 'account_id_payulatam',
                    'label' => esc_html__('Account ID', 'traveler-payulatam'),
                    'type' => 'text',
                    'std' => '',
                    'class' => 'input-sm',
                    'desc' => esc_html__('Enter your Account ID', 'traveler-payulatam'),
                    'section' => 'option_pmgateway'
                ],
                [
                    'id' => 'apikey_payulatam',
                    'label' => esc_html__('API Key', 'traveler-payulatam'),
                    'type' => 'text',
                    'std' => '',
                    'class' => 'input-sm',
                    'desc' => esc_html__('Enter your API Key', 'traveler-payulatam'),
                    'section' => 'option_pmgateway'
                ],
                [
                    'id' => 'api_login_payulatam',
                    'label' => esc_html__('API Login', 'traveler-payulatam'),
                    'type' => 'text',
                    'std' => '',
                    'class' => 'input-sm',
                    'desc' => esc_html__('Enter your API Login', 'traveler-payulatam'),
                    'section' => 'option_pmgateway'
                ],
                [
                    'id' => 'merchant_id_payulatam',
                    'label' => esc_html__('Merchant ID', 'traveler-payulatam'),
                    'type' => 'text',
                    'std' => '',
                    'class' => 'input-sm',
                    'desc' => esc_html__('Enter your Merchant ID', 'traveler-payulatam'),
                    'section' => 'option_pmgateway'
                ],
                [
                    'id' => 'language_payulatam',
                    'label' => esc_html__('Language', 'traveler-payulatam'),
                    'type' => 'select',
                    'choices' => [
                        [
                            'label' => esc_html__('English', 'traveler-payulatam'),
                            'value' => 'EN'
                        ],
                        [
                            'label' => esc_html__('Spanish', 'traveler-payulatam'),
                            'value' => 'ES'
                        ],
                        [
                            'label' => esc_html__('Portuguese', 'traveler-payulatam'),
                            'value' => 'PT'
                        ],
                    ],
                    'std' => 'EN',
                    'section' => 'option_pmgateway'
                ],
            );
        }

        function _pre_checkout_validate()
        {
            return true;
        }

        public function setDefaultParams()
        {

            PayU::$apiKey = st()->get_option('apikey_payulatam'); //Enter your own apiKey here.
            PayU::$apiLogin = st()->get_option('api_login_payulatam'); //Enter your own apiLogin here.
            PayU::$merchantId = st()->get_option('merchant_id_payulatam'); //Enter your commerce Id here.
            $lang = st()->get_option('language_payulatam', 'EN');
            switch ($lang) {
                case 'EN':
                    PayU::$language = SupportedLanguages::EN;
                    break;
                case 'ES':
                    PayU::$language = SupportedLanguages::ES;
                    break;
                case 'PT':
                    PayU::$language = SupportedLanguages::PT;
                    break;
            }

            if (st()->get_option('test_mode_payulatam') == 'on') {
                PayU::$isTest = true;
            }
            Environment::setPaymentsCustomUrl("https://sandbox.api.payulatam.com/payments-api/4.0/service.cgi");
            Environment::setReportsCustomUrl("https://sandbox.api.payulatam.com/reports-api/4.0/service.cgi");
            Environment::setSubscriptionsCustomUrl("https://sandbox.api.payulatam.com/payments-api/rest/v4.3/");
        }

        function do_checkout($order_id)
        {
            $this->setDefaultParams();

            $parameters = $this->getCardParams($order_id);
            try {
                $response = PayUPayments::doAuthorizationAndCapture($parameters);
                if ($response) {
                    if ($response->transactionResponse->state == "APPROVED") {
                        return [
                            'status' => true,
                            'redirect' => $this->get_return_url($order_id)
                        ];
                    } elseif ($response->transactionResponse->state == 'REJECTED' || $response->transactionResponse->state == 'PENDING' || $response->transactionResponse->state == 'DECLINED') {
                        return [
                            'status' => true,
                            'redirect' => $this->get_cancel_url($order_id)
                        ];
                    } else {
                        return [
                            'status' => false,
                            'message' => sprintf(esc_html__('Error code: %s', 'traveler-payulatam'), $response->transactionResponse->responseMessage),
                        ];
                    }
                }
            } catch (\Exception $e) {
                return [
                    'status' => false,
                    'message' => sprintf(esc_html__('Error code: %s', 'traveler-payulatam'), $e->getMessage())
                ];
            }
        }

        function package_do_checkout($order_id){
            if (!class_exists('STAdminPackages')) {
                return ['status' => TravelHelper::st_encrypt($order_id . 'st0'), 'message' => __('This function is off', 'traveler-payulatam')];
            }

            $this->setDefaultParams();
            $order = STAdminPackages::get_inst()->get('*', $order_id);

            $total = round((float)$order->package_price, 2);

            $parameters = [
                PayUParameters::ACCOUNT_ID => st()->get_option('account_id_payulatam'),
                PayUParameters::REFERENCE_CODE => "ORD_" . $order_id . '-' . time(),
                PayUParameters::DESCRIPTION => __('Member Package', 'traveler-payulatam'),

                PayUParameters::VALUE => $total,
                PayUParameters::CURRENCY => 'ARS',

                PayUParameters::BUYER_NAME => STInput::post( 'st_first_name', true) . ' ' . STInput::post( 'st_last_name', true),
                PayUParameters::BUYER_EMAIL => STInput::post( 'st_email', true),
                PayUParameters::BUYER_CONTACT_PHONE => STInput::post( 'st_phone', '0123456789'),
                // Enter the address of the buyer here.
                PayUParameters::BUYER_STREET => STInput::post( 'st_address', 'Address'),
                PayUParameters::BUYER_CITY => STInput::post( 'st_city', 'HN'),
                PayUParameters::BUYER_COUNTRY => STInput::post( 'st_country', 'VN'),
                PayUParameters::BUYER_POSTAL_CODE => STInput::post( 'st_zip_code', true),
                PayUParameters::BUYER_PHONE => STInput::post( 'st_phone', true),

                // -- Payer --
                PayUParameters::PAYER_NAME => STInput::post( 'st_first_name', 'Admin'),
                PayUParameters::PAYER_EMAIL => STInput::post( 'st_email', true),
                PayUParameters::PAYER_CONTACT_PHONE => STInput::post( 'st_phone', '0123456789'),
                PayUParameters::PAYER_STREET => STInput::post( 'st_address', 'Address'),
                PayUParameters::PAYER_CITY => STInput::post( 'st_city', true),
                PayUParameters::PAYER_COUNTRY => STInput::post( 'st_country', 'VN'),
                PayUParameters::PAYER_POSTAL_CODE => STInput::post( 'st_zip_code', '10000'),
                PayUParameters::PAYER_PHONE => STInput::post( 'st_phone', true),

                // -- Credit card data --
                // Enter the number of credit card here
                PayUParameters::CREDIT_CARD_NUMBER => STInput::post('st_payulatam_card_number', ''),
                // Enter the expiration date of the credit card here
                PayUParameters::CREDIT_CARD_EXPIRATION_DATE => trim(STInput::post('st_payulatam_card_expiry_year', '')) . '/' . trim(STInput::post('st_payulatam_card_expiry_month', '')),
                // Enter the security code of the credit card here
                PayUParameters::CREDIT_CARD_SECURITY_CODE => STInput::post('st_payulatam_card_code', ''),
                // Enter the credit card name here.
                //VISA||MASTERCARD||AMEX||DINERS
                PayUParameters::PAYMENT_METHOD => STInput::post('st_payulatam_card_type', 'VISA'),

                // Enter the number of installments here.
                PayUParameters::INSTALLMENTS_NUMBER => "1",
            ];

            $country = STInput::post('st_payulatam_card_country', 'AR');
            switch ($country) {
                case 'AR':
                    $parameters[PayUParameters::COUNTRY] = PayUCountries::AR;
                    break;
                case 'BR':
                    $parameters[PayUParameters::COUNTRY] = PayUCountries::BR;
                    break;
                case 'CL':
                    $parameters[PayUParameters::COUNTRY] = PayUCountries::CL;
                    break;
                case 'CO':
                    $parameters[PayUParameters::COUNTRY] = PayUCountries::CO;
                    break;
                case 'MX':
                    $parameters[PayUParameters::COUNTRY] = PayUCountries::MX;
                    break;
                case 'PA':
                    $parameters[PayUParameters::COUNTRY] = PayUCountries::PA;
                    break;
                case 'PE':
                    $parameters[PayUParameters::COUNTRY] = PayUCountries::PE;
                    break;
                case 'US':
                    $parameters[PayUParameters::COUNTRY] = PayUCountries::US;
                    break;
                default:
                    $parameters[PayUParameters::COUNTRY] = PayUCountries::US;
                    break;
            }

            try {
                $response = PayUPayments::doAuthorizationAndCapture($parameters);
                if ($response) {
                    if ($response->transactionResponse->state == "APPROVED") {
                        return [
                            'status' => TravelHelper::st_encrypt( $order_id . 'st1' ),
                            'redirect_url' => STAdminPackages::get_inst()->get_return_url($order_id)
                        ];
                    } elseif ($response->transactionResponse->state == 'REJECTED' || $response->transactionResponse->state == 'PENDING' || $response->transactionResponse->state == 'DECLINED') {
                        return [
                            'status' => TravelHelper::st_encrypt( $order_id . 'st1' ),
                            'redirect_url' => STAdminPackages::get_inst()->get_cancel_url($order_id)
                        ];
                    } else {
                        return [
                            'status' => TravelHelper::st_encrypt( $order_id . 'st0' ),
                            'message' => sprintf(esc_html__('Error code: %s', 'traveler-payulatam'), $response->transactionResponse->responseMessage),
                        ];
                    }
                }
            } catch (\Exception $e) {
                return [
                    'status' => TravelHelper::st_encrypt( $order_id . 'st0' ),
                    'message' => sprintf(esc_html__('Error code: %s', 'traveler-payulatam'), $e->getMessage())
                ];
            }
        }

        public function getCardParams($order_id)
        {
            $total = get_post_meta($order_id, 'total_price', true);
            $total = round((float)$total, 2);
            $service_id = (int)get_post_meta($order_id, 'item_id', true);

            $parameters = [
                PayUParameters::ACCOUNT_ID => st()->get_option('account_id_payulatam'),
                PayUParameters::REFERENCE_CODE => "ORD_" . $order_id . '-' . time(),
                PayUParameters::DESCRIPTION => get_the_title($service_id),

                PayUParameters::VALUE => $total,
                PayUParameters::CURRENCY => 'ARS',

                PayUParameters::BUYER_NAME => get_post_meta($order_id, 'st_first_name', true) . ' ' . get_post_meta($order_id, 'st_last_name', true),
                PayUParameters::BUYER_EMAIL => get_post_meta($order_id, 'st_email', true),
                PayUParameters::BUYER_CONTACT_PHONE => get_post_meta($order_id, 'st_phone', true),
                // Enter the address of the buyer here.
                PayUParameters::BUYER_STREET => get_post_meta($order_id, 'st_address', true),
                PayUParameters::BUYER_CITY => get_post_meta($order_id, 'st_city', true),
                PayUParameters::BUYER_COUNTRY => get_post_meta($order_id, 'st_country', true),
                PayUParameters::BUYER_POSTAL_CODE => get_post_meta($order_id, 'st_zip_code', true),
                PayUParameters::BUYER_PHONE => get_post_meta($order_id, 'st_phone', true),

                // -- Payer --
                PayUParameters::PAYER_NAME => get_post_meta($order_id, 'st_first_name', true),
                PayUParameters::PAYER_EMAIL => get_post_meta($order_id, 'st_email', true),
                PayUParameters::PAYER_CONTACT_PHONE => get_post_meta($order_id, 'st_phone', true),
                PayUParameters::PAYER_STREET => get_post_meta($order_id, 'st_address', true),
                PayUParameters::PAYER_CITY => get_post_meta($order_id, 'st_city', true),
                PayUParameters::PAYER_COUNTRY => get_post_meta($order_id, 'st_country', true),
                PayUParameters::PAYER_POSTAL_CODE => get_post_meta($order_id, 'st_zip_code', true),
                PayUParameters::PAYER_PHONE => get_post_meta($order_id, 'st_phone', true),

                // -- Credit card data --
                // Enter the number of credit card here
                PayUParameters::CREDIT_CARD_NUMBER => STInput::post('st_payulatam_card_number', ''),
                // Enter the expiration date of the credit card here
                PayUParameters::CREDIT_CARD_EXPIRATION_DATE => trim(STInput::post('st_payulatam_card_expiry_year', '')) . '/' . trim(STInput::post('st_payulatam_card_expiry_month', '')),
                // Enter the security code of the credit card here
                PayUParameters::CREDIT_CARD_SECURITY_CODE => STInput::post('st_payulatam_card_code', ''),
                // Enter the credit card name here.
                //VISA||MASTERCARD||AMEX||DINERS
                PayUParameters::PAYMENT_METHOD => STInput::post('st_payulatam_card_type', 'VISA'),

                // Enter the number of installments here.
                PayUParameters::INSTALLMENTS_NUMBER => "1",
            ];

            $country = STInput::post('st_payulatam_card_country', 'AR');
            switch ($country) {
                case 'AR':
                    $parameters[PayUParameters::COUNTRY] = PayUCountries::AR;
                    break;
                case 'BR':
                    $parameters[PayUParameters::COUNTRY] = PayUCountries::BR;
                    break;
                case 'CL':
                    $parameters[PayUParameters::COUNTRY] = PayUCountries::CL;
                    break;
                case 'CO':
                    $parameters[PayUParameters::COUNTRY] = PayUCountries::CO;
                    break;
                case 'MX':
                    $parameters[PayUParameters::COUNTRY] = PayUCountries::MX;
                    break;
                case 'PA':
                    $parameters[PayUParameters::COUNTRY] = PayUCountries::PA;
                    break;
                case 'PE':
                    $parameters[PayUParameters::COUNTRY] = PayUCountries::PE;
                    break;
                case 'US':
                    $parameters[PayUParameters::COUNTRY] = PayUCountries::US;
                    break;
                default:
                    $parameters[PayUParameters::COUNTRY] = PayUCountries::US;
                    break;
            }

            return $parameters;
        }

        function check_complete_purchase($order_id)
        {
            return false;
        }

        function package_completed_checkout($order_id){
            if (!class_exists('STAdminPackages')) {
                return ['status' => false];
            }

            $status = STInput::get('status');
            if ( TravelHelper::st_compare_encrypt( (int) $order_id . 'st1', $status ) ) {
                return true;
            }
        }
        function is_check_complete_required()
        {
            return true;
        }

        function html()
        {
            echo Traveler_PayuLatam_Payment::get_inst()->loadTemplate('payulatam');
        }

        function get_name()
        {
            return __('PayULatam', 'traveler-payu');
        }

        function get_default_status()
        {
            return $this->default_status;
        }

        function is_available($item_id = false)
        {
            if (st()->get_option('pm_gway_st_payulatam_enable') == 'off') {
                return false;
            } else {
                if (!st()->get_option('account_id_payulatam')) {
                    return false;
                }
                if (!st()->get_option('apikey_payulatam')) {
                    return false;
                }
            }

            if ($item_id) {
                $meta = get_post_meta($item_id, 'is_meta_payment_gateway_st_payulatam', true);
                if ($meta == 'off') {
                    return false;
                }
            }

            return true;
        }

        function getGatewayId()
        {
            return $this->_gateway_id;
        }

        function get_logo()
        {
            return Traveler_PayuLatam_Payment::get_inst()->pluginUrl . 'assets/img/payu_latin.png';
        }

        static function instance()
        {
            if (!self::$_ints) {
                self::$_ints = new self();
            }

            return self::$_ints;
        }

        static function add_payment($payment)
        {
            $payment['st_payulatam'] = self::instance();

            return $payment;
        }
    }

    add_filter('st_payment_gateways', array('ST_PayuLatam_Payment_Gateway', 'add_payment'));
}