<?php
/**
 * Created by PhpStorm.
 * User: Dungdt
 * Date: 12/15/2015
 * Time: 3:19 PM
 */


if (!class_exists('ST_Onepay_ATM_Payment_Gateway')) {
    class ST_Onepay_ATM_Payment_Gateway extends STAbstactPaymentGateway
    {
        static private $_ints;
        private $default_status = true;
        private $_gatewayObject = null;
        private $_gateway_id = 'st_onepay_atm';

        private $url;
        private $merchant_id;
        private $merchant_access_code;
        private $secure_secret;

        function __construct()
        {
            add_filter('st_payment_gateway_st_onepay_atm_name', array($this, 'get_name'));
            try {
                $this->_gatewayObject = '';

            } catch (Exception $e) {
                $this->default_status = false;
            }
        }


        function get_option_fields()
        {
            return array(
                array(
                    'id' => 'onepay_url',
                    'label' => __('URL', 'traveler-onepay-atm'),
                    'type' => 'text',
                    'section' => 'option_pmgateway',
                    'desc' => esc_html__("Information connect or Environment test. Url for real: https://onepay.vn/onecomm-pay/vpc.op, Url for test: https://mtf.onepay.vn/onecomm-pay/vpc.op", 'traveler-onepay-atm'),
                    'condition' => 'pm_gway_st_onepay_atm_enable:is(on)'
                ),
                array(
                    'id' => 'onepay_merchant_id',
                    'label' => __('Merchant ID', 'traveler-onepay-atm'),
                    'type' => 'text',
                    'section' => 'option_pmgateway',
                    'desc' => __('Merchant ID', 'traveler-onepay-atm'),
                    'condition' => 'pm_gway_st_onepay_atm_enable:is(on)'
                ),
                array(
                    'id' => 'onepay_merchant_access_code',
                    'label' => __('Merchant Access Code', 'traveler-onepay-atm'),
                    'type' => 'text',
                    'section' => 'option_pmgateway',
                    'desc' => __('Merchant Access Code', 'traveler-onepay-atm'),
                    'condition' => 'pm_gway_st_onepay_atm_enable:is(on)'
                ),
                array(
                    'id' => 'onepay_secure_secret',
                    'label' => __('Security Secret', 'traveler-onepay-atm'),
                    'type' => 'text',
                    'section' => 'option_pmgateway',
                    'desc' => __('Security Secret', 'traveler-onepay-atm'),
                    'condition' => 'pm_gway_st_onepay_atm_enable:is(on)'
                ),
            );
        }

        public function setDefaultParam()
        {
            $this->url = st()->get_option('onepay_url', '');
            $this->merchant_id = st()->get_option('onepay_merchant_id', '');
            $this->merchant_access_code = st()->get_option('onepay_merchant_access_code', '');
            $this->secure_secret = st()->get_option('onepay_secure_secret', '');
        }

        function _pre_checkout_validate()
        {
            if (TravelHelper::get_current_currency('name') != 'VND') {
                STTemplate::set_message(__('This payment only supports VND currency', 'traveler-onpepay-atm'));
                return false;
            }

            return true;
        }

        function do_checkout($order_id)
        {
            if (!$this->is_available()) {
                return
                    [
                        'status' => 0,
                        'complete_purchase' => 0,
                        'error_type' => 'card_validate',
                        'error_fields' => '',
                    ];
            }

            $this->setDefaultParam();
            $lang = get_bloginfo("language"); // get current language of website
            if ($lang == "vi") {
                $vpc_Locale = "vn";
            } else $vpc_Locale = "en";

            $total = get_post_meta($order_id, 'total_price', true);
            $total = round((float)$total, 2);

            $op_var = array(

                'AgainLink' => 'onepay.vn',
                'Title' => 'onepay.vn',
                'vpc_Locale' => $vpc_Locale,
                'vpc_Version' => '2',
                'vpc_Command' => 'pay',
                'vpc_Currency' => 'VND',
                'vpc_Merchant' => $this->merchant_id,
                'vpc_AccessCode' => $this->merchant_access_code,
                'vpc_MerchTxnRef' => date('YmdHis') . rand(),
                'vpc_OrderInfo' => $order_id,
                'vpc_Amount' => $total * 100,
                'vpc_ReturnURL' => $this->get_return_url($order_id),
                'vpc_TicketNo' => $_SERVER["REMOTE_ADDR"]
            );
            $onepay_url = $this->url;
            $stringHashData = "";
            ksort($op_var);
            $appendAmp = 0;
            $onepay_url .= "?";

            foreach ($op_var as $key => $value) {

                if (strlen($value) > 0) {
                    if ($appendAmp == 0) {
                        $onepay_url .= urlencode($key) . '=' . urlencode($value);
                        $appendAmp = 1;
                    } else {
                        $onepay_url .= '&' . urlencode($key) . "=" . urlencode($value);
                    }
                    if ((strlen($value) > 0) && ((substr($key, 0, 4) == "vpc_") || (substr($key, 0, 5) == "user_"))) {
                        $stringHashData .= $key . "=" . $value . "&";

                    }
                }
            }
            $stringHashData = rtrim($stringHashData, "&");
            if (strlen($this->secure_secret) > 0) {
                $onepay_url .= "&vpc_SecureHash=" . strtoupper(hash_hmac('SHA256', $stringHashData, pack('H*', $this->secure_secret)));
            }

            return ['status' => true, 'redirect' => $onepay_url];

        }


        function complete_purchase($order_id)
        {
            return true;
        }

        function check_complete_purchase($order_id)
        {
            $this->setDefaultParam();
            $vpc_Txn_Secure_Hash = $_GET ["vpc_SecureHash"];
            unset ($_GET ["vpc_SecureHash"]);
            $errorExists = false;

            if (strlen($this->secure_secret) > 0 && $_GET ["vpc_TxnResponseCode"] != "7" && $_GET ["vpc_TxnResponseCode"] != "No Value Returned") {
                ksort($_GET);
                $stringHashData = "";

                foreach ($_GET as $key => $value) {
                    if ($key != "vpc_SecureHash" && (strlen($value) > 0) && ((substr($key, 0, 4) == "vpc_") || (substr($key, 0, 5) == "user_"))) {
                        $stringHashData .= $key . "=" . $value . "&";
                    }
                }
                $stringHashData = rtrim($stringHashData, "&");

                if (strtoupper($vpc_Txn_Secure_Hash) == strtoupper(hash_hmac('SHA256', $stringHashData, pack('H*', $this->secure_secret)))) {
                    $hashValidated = "CORRECT";
                } else {
                    $hashValidated = "INVALID HASH";
                }
            } else {
                $hashValidated = "INVALID HASH";
            }

            $amount = $this->null2unknown($_GET ["vpc_Amount"]);
            $orderInfo = $this->null2unknown($_GET ["vpc_OrderInfo"]);
            $txnResponseCode = $this->null2unknown($_GET ["vpc_TxnResponseCode"]);

            $tranDesc = $this->getResponseDescription($txnResponseCode);

            if ($hashValidated == "CORRECT" && $txnResponseCode == "0") {
                return ['status' => true, 'message' => $tranDesc];

            } elseif ($txnResponseCode != "0") {
                return ['status' => false, 'message' => $tranDesc];
            } elseif ($hashValidated == "INVALID HASH") {
                return ['status' => false, 'message' => $tranDesc];
            }

        }

        function getResponseDescription($responseCode)
        {

            switch ($responseCode) {
                case "0" :
                    $result = "Giao dịch thành công - Approved";
                    break;
                case "1" :
                    $result = "Ngân hàng từ chối giao dịch - Bank Declined";
                    break;
                case "3" :
                    $result = "Mã đơn vị không tồn tại - Merchant not exist";
                    break;
                case "4" :
                    $result = "Không đúng access code - Invalid access code";
                    break;
                case "5" :
                    $result = "Số tiền không hợp lệ - Invalid amount";
                    break;
                case "6" :
                    $result = "Mã tiền tệ không tồn tại - Invalid currency code";
                    break;
                case "7" :
                    $result = "Lỗi không xác định - Unspecified Failure ";
                    break;
                case "8" :
                    $result = "Số thẻ không đúng - Invalid card Number";
                    break;
                case "9" :
                    $result = "Tên chủ thẻ không đúng - Invalid card name";
                    break;
                case "10" :
                    $result = "Thẻ hết hạn/Thẻ bị khóa - Expired Card";
                    break;
                case "11" :
                    $result = "Thẻ chưa đăng ký sử dụng dịch vụ - Card Not Registed Service(internet banking)";
                    break;
                case "12" :
                    $result = "Ngày phát hành/Hết hạn không đúng - Invalid card date";
                    break;
                case "13" :
                    $result = "Vượt quá hạn mức thanh toán - Exist Amount";
                    break;
                case "21" :
                    $result = "Số tiền không đủ để thanh toán - Insufficient fund";
                    break;
                case "22" :
                    $result = "Thông tin tài khoản không đúng - Invalid Account";
                    break;
                case "23" :
                    $result = "Tài khoản bị khóa - Account Lock";
                    break;
                case "24" :
                    $result = "Thông tin thẻ không đúng - Invalid Card Info";
                    break;
                case "25" :
                    $result = "OTP không đúng - Invalid OTP";
                    break;
                case "253" :
                    $result = "Quá thời gian thanh toán - Transaction timeout";
                    break;
                case "99" :
                    $result = "Người sủ dụng hủy giao dịch - User cancel";
                    break;
                default :
                    $result = "Giao dịch thất bại - Failured";

            }

            return $result;

        }

        private function null2unknown($data)
        {
            if ($data == "") {
                return "No Value Returned";
            } else {
                return $data;
            }
        }

        function html()
        {
            echo Traveler_Onepay_ATM_Payment::get_inst()->loadTemplate('onepay-atm');
        }

        function get_name()
        {
            return __('Onepay ATM', 'traveler-onepay-atm');
        }

        function get_default_status()
        {
            return $this->default_status;
        }

        function is_available($item_id = false)
        {
            if (st()->get_option('pm_gway_st_onepay_atm_enable') == 'off') {
                return false;
            } else {
                if (!st()->get_option('onepay_merchant_id')) {
                    return false;
                }
            }

            if ($item_id) {
                $meta = get_post_meta($item_id, 'is_meta_payment_gateway_st_onepay_atm', true);
                if ($meta == 'off') {
                    return false;
                }
            }

            return true;
        }

        function getGatewayId()
        {
            return $this->_gateway_id;
        }

        function is_check_complete_required()
        {
            return true;
        }

        function get_logo()
        {
            return Traveler_Onepay_ATM_Payment::get_inst()->pluginUrl . 'assets/img/opatm.png';
        }

        static function instance()
        {
            if (!self::$_ints) {
                self::$_ints = new self();
            }

            return self::$_ints;
        }

        static function add_payment($payment)
        {
            $payment['st_onepay_atm'] = self::instance();

            return $payment;
        }
    }

    add_filter('st_payment_gateways', array('ST_Onepay_ATM_Payment_Gateway', 'add_payment'));
}