(function($){var objCounter=0;$.jqplot.CanvasOverlay=function(opts){var options=opts||{};this.options={show:$.jqplot.config.enablePlugins,deferDraw:!1};this.objects=[];this.objectNames=[];this.canvas=null;this.markerRenderer=new $.jqplot.MarkerRenderer({style:'line'});this.markerRenderer.init();this.highlightObjectIndex=null;if(options.objects){var objs=options.objects,obj;for(var i=0;i<objs.length;i++){obj=objs[i];for(var n in obj){switch(n){case 'line':this.addLine(obj[n]);break;case 'horizontalLine':this.addHorizontalLine(obj[n]);break;case 'dashedHorizontalLine':this.addDashedHorizontalLine(obj[n]);break;case 'verticalLine':this.addVerticalLine(obj[n]);break;case 'dashedVerticalLine':this.addDashedVerticalLine(obj[n]);break;case 'rectangle':this.addRectangle(obj[n]);break;default:break}}}}
$.extend(!0,this.options,options)};$.jqplot.CanvasOverlay.postPlotInit=function(target,data,opts){var options=opts||{};this.plugins.canvasOverlay=new $.jqplot.CanvasOverlay(options.canvasOverlay)};function LineBase(){this.uid=null;this.type=null;this.gridStart=null;this.gridStop=null;this.tooltipWidthFactor=0;this.options={name:null,show:!0,lineWidth:2,lineCap:'round',color:'#666666',shadow:!0,shadowAngle:45,shadowOffset:1,shadowDepth:3,shadowAlpha:'0.07',xaxis:'xaxis',yaxis:'yaxis',showTooltip:!1,showTooltipPrecision:0.6,tooltipLocation:'nw',fadeTooltip:!0,tooltipFadeSpeed:"fast",tooltipOffset:4,tooltipFormatString:'%d, %d'}}
function Rectangle(options){LineBase.call(this);this.type='rectangle';var opts={xmin:null,xmax:null,xOffset:'6px',xminOffset:null,xmaxOffset:null,ymin:null,ymax:null,yOffset:'6px',yminOffset:null,ymaxOffset:null};$.extend(!0,this.options,opts,options);if(this.options.showTooltipPrecision<0.01){this.options.showTooltipPrecision=0.01}}
Rectangle.prototype=new LineBase();Rectangle.prototype.constructor=Rectangle;function Line(options){LineBase.call(this);this.type='line';var opts={start:[],stop:[]};$.extend(!0,this.options,opts,options);if(this.options.showTooltipPrecision<0.01){this.options.showTooltipPrecision=0.01}}
Line.prototype=new LineBase();Line.prototype.constructor=Line;function HorizontalLine(options){LineBase.call(this);this.type='horizontalLine';var opts={y:null,xmin:null,xmax:null,xOffset:'6px',xminOffset:null,xmaxOffset:null};$.extend(!0,this.options,opts,options);if(this.options.showTooltipPrecision<0.01){this.options.showTooltipPrecision=0.01}}
HorizontalLine.prototype=new LineBase();HorizontalLine.prototype.constructor=HorizontalLine;function DashedHorizontalLine(options){LineBase.call(this);this.type='dashedHorizontalLine';var opts={y:null,xmin:null,xmax:null,xOffset:'6px',xminOffset:null,xmaxOffset:null,dashPattern:[8,8]};$.extend(!0,this.options,opts,options);if(this.options.showTooltipPrecision<0.01){this.options.showTooltipPrecision=0.01}}
DashedHorizontalLine.prototype=new LineBase();DashedHorizontalLine.prototype.constructor=DashedHorizontalLine;function VerticalLine(options){LineBase.call(this);this.type='verticalLine';var opts={x:null,ymin:null,ymax:null,yOffset:'6px',yminOffset:null,ymaxOffset:null};$.extend(!0,this.options,opts,options);if(this.options.showTooltipPrecision<0.01){this.options.showTooltipPrecision=0.01}}
VerticalLine.prototype=new LineBase();VerticalLine.prototype.constructor=VerticalLine;function DashedVerticalLine(options){LineBase.call(this);this.type='dashedVerticalLine';this.start=null;this.stop=null;var opts={x:null,ymin:null,ymax:null,yOffset:'6px',yminOffset:null,ymaxOffset:null,dashPattern:[8,8]};$.extend(!0,this.options,opts,options);if(this.options.showTooltipPrecision<0.01){this.options.showTooltipPrecision=0.01}}
DashedVerticalLine.prototype=new LineBase();DashedVerticalLine.prototype.constructor=DashedVerticalLine;$.jqplot.CanvasOverlay.prototype.addLine=function(opts){var line=new Line(opts);line.uid=objCounter++;this.objects.push(line);this.objectNames.push(line.options.name)};$.jqplot.CanvasOverlay.prototype.addHorizontalLine=function(opts){var line=new HorizontalLine(opts);line.uid=objCounter++;this.objects.push(line);this.objectNames.push(line.options.name)};$.jqplot.CanvasOverlay.prototype.addDashedHorizontalLine=function(opts){var line=new DashedHorizontalLine(opts);line.uid=objCounter++;this.objects.push(line);this.objectNames.push(line.options.name)};$.jqplot.CanvasOverlay.prototype.addVerticalLine=function(opts){var line=new VerticalLine(opts);line.uid=objCounter++;this.objects.push(line);this.objectNames.push(line.options.name)};$.jqplot.CanvasOverlay.prototype.addDashedVerticalLine=function(opts){var line=new DashedVerticalLine(opts);line.uid=objCounter++;this.objects.push(line);this.objectNames.push(line.options.name)};$.jqplot.CanvasOverlay.prototype.addRectangle=function(opts){var line=new Rectangle(opts);line.uid=objCounter++;this.objects.push(line);this.objectNames.push(line.options.name)};$.jqplot.CanvasOverlay.prototype.removeObject=function(idx){if($.type(idx)=='number'){this.objects.splice(idx,1);this.objectNames.splice(idx,1)}
else{var id=$.inArray(idx,this.objectNames);if(id!=-1){this.objects.splice(id,1);this.objectNames.splice(id,1)}}};$.jqplot.CanvasOverlay.prototype.getObject=function(idx){if($.type(idx)=='number'){return this.objects[idx]}
else{var id=$.inArray(idx,this.objectNames);if(id!=-1){return this.objects[id]}}};$.jqplot.CanvasOverlay.prototype.get=$.jqplot.CanvasOverlay.prototype.getObject;$.jqplot.CanvasOverlay.prototype.clear=function(plot){this.canvas._ctx.clearRect(0,0,this.canvas.getWidth(),this.canvas.getHeight())};$.jqplot.CanvasOverlay.prototype.draw=function(plot){var obj,objs=this.objects,mr=this.markerRenderer,start,stop;if(this.options.show){this.canvas._ctx.clearRect(0,0,this.canvas.getWidth(),this.canvas.getHeight());for(var k=0;k<objs.length;k++){obj=objs[k];var opts=$.extend(!0,{},obj.options);if(obj.options.show){mr.shadow=obj.options.shadow;obj.tooltipWidthFactor=obj.options.lineWidth/obj.options.showTooltipPrecision;switch(obj.type){case 'line':mr.style='line';opts.closePath=!1;start=[plot.axes[obj.options.xaxis].series_u2p(obj.options.start[0]),plot.axes[obj.options.yaxis].series_u2p(obj.options.start[1])];stop=[plot.axes[obj.options.xaxis].series_u2p(obj.options.stop[0]),plot.axes[obj.options.yaxis].series_u2p(obj.options.stop[1])];obj.gridStart=start;obj.gridStop=stop;mr.draw(start,stop,this.canvas._ctx,opts);break;case 'horizontalLine':if(obj.options.y!=null){mr.style='line';opts.closePath=!1;var xaxis=plot.axes[obj.options.xaxis],xstart,xstop,y=plot.axes[obj.options.yaxis].series_u2p(obj.options.y),xminoff=obj.options.xminOffset||obj.options.xOffset,xmaxoff=obj.options.xmaxOffset||obj.options.xOffset;if(obj.options.xmin!=null){xstart=xaxis.series_u2p(obj.options.xmin)}
else if(xminoff!=null){if($.type(xminoff)=="number"){xstart=xaxis.series_u2p(xaxis.min+xminoff)}
else if($.type(xminoff)=="string"){xstart=xaxis.series_u2p(xaxis.min)+parseFloat(xminoff)}}
if(obj.options.xmax!=null){xstop=xaxis.series_u2p(obj.options.xmax)}
else if(xmaxoff!=null){if($.type(xmaxoff)=="number"){xstop=xaxis.series_u2p(xaxis.max-xmaxoff)}
else if($.type(xmaxoff)=="string"){xstop=xaxis.series_u2p(xaxis.max)-parseFloat(xmaxoff)}}
if(xstop!=null&&xstart!=null){obj.gridStart=[xstart,y];obj.gridStop=[xstop,y];mr.draw([xstart,y],[xstop,y],this.canvas._ctx,opts)}}
break;case 'dashedHorizontalLine':var dashPat=obj.options.dashPattern;var dashPatLen=0;for(var i=0;i<dashPat.length;i++){dashPatLen+=dashPat[i]}
if(obj.options.y!=null){mr.style='line';opts.closePath=!1;var xaxis=plot.axes[obj.options.xaxis],xstart,xstop,y=plot.axes[obj.options.yaxis].series_u2p(obj.options.y),xminoff=obj.options.xminOffset||obj.options.xOffset,xmaxoff=obj.options.xmaxOffset||obj.options.xOffset;if(obj.options.xmin!=null){xstart=xaxis.series_u2p(obj.options.xmin)}
else if(xminoff!=null){if($.type(xminoff)=="number"){xstart=xaxis.series_u2p(xaxis.min+xminoff)}
else if($.type(xminoff)=="string"){xstart=xaxis.series_u2p(xaxis.min)+parseFloat(xminoff)}}
if(obj.options.xmax!=null){xstop=xaxis.series_u2p(obj.options.xmax)}
else if(xmaxoff!=null){if($.type(xmaxoff)=="number"){xstop=xaxis.series_u2p(xaxis.max-xmaxoff)}
else if($.type(xmaxoff)=="string"){xstop=xaxis.series_u2p(xaxis.max)-parseFloat(xmaxoff)}}
if(xstop!=null&&xstart!=null){obj.gridStart=[xstart,y];obj.gridStop=[xstop,y];var numDash=Math.ceil((xstop-xstart)/dashPatLen);var b=xstart,e;for(var i=0;i<numDash;i++){for(var j=0;j<dashPat.length;j+=2){e=b+dashPat[j];mr.draw([b,y],[e,y],this.canvas._ctx,opts);b+=dashPat[j];if(j<dashPat.length-1){b+=dashPat[j+1]}}}}}
break;case 'verticalLine':if(obj.options.x!=null){mr.style='line';opts.closePath=!1;var yaxis=plot.axes[obj.options.yaxis],ystart,ystop,x=plot.axes[obj.options.xaxis].series_u2p(obj.options.x),yminoff=obj.options.yminOffset||obj.options.yOffset,ymaxoff=obj.options.ymaxOffset||obj.options.yOffset;if(obj.options.ymin!=null){ystart=yaxis.series_u2p(obj.options.ymin)}
else if(yminoff!=null){if($.type(yminoff)=="number"){ystart=yaxis.series_u2p(yaxis.min-yminoff)}
else if($.type(yminoff)=="string"){ystart=yaxis.series_u2p(yaxis.min)-parseFloat(yminoff)}}
if(obj.options.ymax!=null){ystop=yaxis.series_u2p(obj.options.ymax)}
else if(ymaxoff!=null){if($.type(ymaxoff)=="number"){ystop=yaxis.series_u2p(yaxis.max+ymaxoff)}
else if($.type(ymaxoff)=="string"){ystop=yaxis.series_u2p(yaxis.max)+parseFloat(ymaxoff)}}
if(ystop!=null&&ystart!=null){obj.gridStart=[x,ystart];obj.gridStop=[x,ystop];mr.draw([x,ystart],[x,ystop],this.canvas._ctx,opts)}}
break;case 'dashedVerticalLine':var dashPat=obj.options.dashPattern;var dashPatLen=0;for(var i=0;i<dashPat.length;i++){dashPatLen+=dashPat[i]}
if(obj.options.x!=null){mr.style='line';opts.closePath=!1;var yaxis=plot.axes[obj.options.yaxis],ystart,ystop,x=plot.axes[obj.options.xaxis].series_u2p(obj.options.x),yminoff=obj.options.yminOffset||obj.options.yOffset,ymaxoff=obj.options.ymaxOffset||obj.options.yOffset;if(obj.options.ymin!=null){ystart=yaxis.series_u2p(obj.options.ymin)}
else if(yminoff!=null){if($.type(yminoff)=="number"){ystart=yaxis.series_u2p(yaxis.min-yminoff)}
else if($.type(yminoff)=="string"){ystart=yaxis.series_u2p(yaxis.min)-parseFloat(yminoff)}}
if(obj.options.ymax!=null){ystop=yaxis.series_u2p(obj.options.ymax)}
else if(ymaxoff!=null){if($.type(ymaxoff)=="number"){ystop=yaxis.series_u2p(yaxis.max+ymaxoff)}
else if($.type(ymaxoff)=="string"){ystop=yaxis.series_u2p(yaxis.max)+parseFloat(ymaxoff)}}
if(ystop!=null&&ystart!=null){obj.gridStart=[x,ystart];obj.gridStop=[x,ystop];var numDash=Math.ceil((ystart-ystop)/dashPatLen);var firstDashAdjust=((numDash*dashPatLen)-(ystart-ystop))/2.0;var b=ystart,e,bs,es;for(var i=0;i<numDash;i++){for(var j=0;j<dashPat.length;j+=2){e=b-dashPat[j];if(e<ystop){e=ystop}
if(b<ystop){b=ystop}
mr.draw([x,b],[x,e],this.canvas._ctx,opts);b-=dashPat[j];if(j<dashPat.length-1){b-=dashPat[j+1]}}}}}
break;case 'rectangle':mr.style='line';opts.closePath=!0;var xaxis=plot.axes[obj.options.xaxis],xstart,xstop,y=plot.axes[obj.options.yaxis].series_u2p(obj.options.y),xminoff=obj.options.xminOffset||obj.options.xOffset,xmaxoff=obj.options.xmaxOffset||obj.options.xOffset;if(obj.options.xmin!=null){xstart=xaxis.series_u2p(obj.options.xmin)}
else if(xminoff!=null){if($.type(xminoff)=="number"){xstart=xaxis.series_u2p(xaxis.min+xminoff)}
else if($.type(xminoff)=="string"){xstart=xaxis.series_u2p(xaxis.min)+parseFloat(xminoff)}}
if(obj.options.xmax!=null){xstop=xaxis.series_u2p(obj.options.xmax)}
else if(xmaxoff!=null){if($.type(xmaxoff)=="number"){xstop=xaxis.series_u2p(xaxis.max-xmaxoff)}
else if($.type(xmaxoff)=="string"){xstop=xaxis.series_u2p(xaxis.max)-parseFloat(xmaxoff)}}
var yaxis=plot.axes[obj.options.yaxis],ystart,ystop,x=plot.axes[obj.options.xaxis].series_u2p(obj.options.x),yminoff=obj.options.yminOffset||obj.options.yOffset,ymaxoff=obj.options.ymaxOffset||obj.options.yOffset;if(obj.options.ymin!=null){ystart=yaxis.series_u2p(obj.options.ymin)}
else if(yminoff!=null){if($.type(yminoff)=="number"){ystart=yaxis.series_u2p(yaxis.min-yminoff)}
else if($.type(yminoff)=="string"){ystart=yaxis.series_u2p(yaxis.min)-parseFloat(yminoff)}}
if(obj.options.ymax!=null){ystop=yaxis.series_u2p(obj.options.ymax)}
else if(ymaxoff!=null){if($.type(ymaxoff)=="number"){ystop=yaxis.series_u2p(yaxis.max+ymaxoff)}
else if($.type(ymaxoff)=="string"){ystop=yaxis.series_u2p(yaxis.max)+parseFloat(ymaxoff)}}
if(xstop!=null&&xstart!=null&&ystop!=null&&ystart!=null){obj.gridStart=[xstart,ystart];obj.gridStop=[xstop,ystop];this.canvas._ctx.fillStyle=obj.options.color;this.canvas._ctx.fillRect(xstart,ystart,xstop-xstart,ystop-ystart)}
break;default:break}}}}};$.jqplot.CanvasOverlay.postPlotDraw=function(){var co=this.plugins.canvasOverlay;if(co&&co.highlightCanvas){co.highlightCanvas.resetCanvas();co.highlightCanvas=null}
co.canvas=new $.jqplot.GenericCanvas();this.eventCanvas._elem.before(co.canvas.createElement(this._gridPadding,'jqplot-overlayCanvas-canvas',this._plotDimensions,this));co.canvas.setContext();if(!co.deferDraw){co.draw(this)}
var elem=document.createElement('div');co._tooltipElem=$(elem);elem=null;co._tooltipElem.addClass('jqplot-canvasOverlay-tooltip');co._tooltipElem.css({position:'absolute',display:'none'});this.eventCanvas._elem.before(co._tooltipElem);this.eventCanvas._elem.bind('mouseleave',{elem:co._tooltipElem},function(ev){ev.data.elem.hide()});var co=null};function showTooltip(plot,obj,gridpos,datapos){var co=plot.plugins.canvasOverlay;var elem=co._tooltipElem;var opts=obj.options,x,y;elem.html($.jqplot.sprintf(opts.tooltipFormatString,datapos[0],datapos[1]));switch(opts.tooltipLocation){case 'nw':x=gridpos[0]+plot._gridPadding.left-elem.outerWidth(!0)-opts.tooltipOffset;y=gridpos[1]+plot._gridPadding.top-opts.tooltipOffset-elem.outerHeight(!0);break;case 'n':x=gridpos[0]+plot._gridPadding.left-elem.outerWidth(!0)/2;y=gridpos[1]+plot._gridPadding.top-opts.tooltipOffset-elem.outerHeight(!0);break;case 'ne':x=gridpos[0]+plot._gridPadding.left+opts.tooltipOffset;y=gridpos[1]+plot._gridPadding.top-opts.tooltipOffset-elem.outerHeight(!0);break;case 'e':x=gridpos[0]+plot._gridPadding.left+opts.tooltipOffset;y=gridpos[1]+plot._gridPadding.top-elem.outerHeight(!0)/2;break;case 'se':x=gridpos[0]+plot._gridPadding.left+opts.tooltipOffset;y=gridpos[1]+plot._gridPadding.top+opts.tooltipOffset;break;case 's':x=gridpos[0]+plot._gridPadding.left-elem.outerWidth(!0)/2;y=gridpos[1]+plot._gridPadding.top+opts.tooltipOffset;break;case 'sw':x=gridpos[0]+plot._gridPadding.left-elem.outerWidth(!0)-opts.tooltipOffset;y=gridpos[1]+plot._gridPadding.top+opts.tooltipOffset;break;case 'w':x=gridpos[0]+plot._gridPadding.left-elem.outerWidth(!0)-opts.tooltipOffset;y=gridpos[1]+plot._gridPadding.top-elem.outerHeight(!0)/2;break;default:x=gridpos[0]+plot._gridPadding.left-elem.outerWidth(!0)-opts.tooltipOffset;y=gridpos[1]+plot._gridPadding.top-opts.tooltipOffset-elem.outerHeight(!0);break}
elem.css('left',x);elem.css('top',y);if(opts.fadeTooltip){elem.stop(!0,!0).fadeIn(opts.tooltipFadeSpeed)}
else{elem.show()}
elem=null}
function isNearLine(point,lstart,lstop,width){var rx=point[0];var ry=point[1];var px=Math.round(lstop[0]);var py=Math.round(lstop[1]);var qx=Math.round(lstart[0]);var qy=Math.round(lstart[1]);var l=Math.sqrt(Math.pow(px-qx,2)+Math.pow(py-qy,2));var eps=width*l;var res=Math.abs((qx-px)*(ry-py)-(qy-py)*(rx-px));var ret=(res<eps)?!0:!1;return ret}
function isNearRectangle(point,lstart,lstop,width){var rx=point[0];var ry=point[1];var px=Math.round(lstop[0]);var py=Math.round(lstop[1]);var qx=Math.round(lstart[0]);var qy=Math.round(lstart[1]);var temp;if(px>qx){temp=px;px=qx;qx=temp}
if(py>qy){temp=py;py=qy;qy=temp}
var ret=(rx>=px&&rx<=qx&&ry>=py&&ry<=qy);return ret}
function handleMove(ev,gridpos,datapos,neighbor,plot){var co=plot.plugins.canvasOverlay;var objs=co.objects;var l=objs.length;var obj,haveHighlight=!1;var elem;for(var i=0;i<l;i++){obj=objs[i];if(obj.options.showTooltip){var n;if(obj.type==='rectangle'){n=isNearRectangle([gridpos.x,gridpos.y],obj.gridStart,obj.gridStop,obj.tooltipWidthFactor)}else{n=isNearLine([gridpos.x,gridpos.y],obj.gridStart,obj.gridStop,obj.tooltipWidthFactor)}
datapos=[plot.axes[obj.options.xaxis].series_p2u(gridpos.x),plot.axes[obj.options.yaxis].series_p2u(gridpos.y)];if(n&&co.highlightObjectIndex==null){switch(obj.type){case 'line':showTooltip(plot,obj,[gridpos.x,gridpos.y],datapos);break;case 'horizontalLine':case 'dashedHorizontalLine':showTooltip(plot,obj,[gridpos.x,obj.gridStart[1]],[datapos[0],obj.options.y]);break;case 'verticalLine':case 'dashedVerticalLine':showTooltip(plot,obj,[obj.gridStart[0],gridpos.y],[obj.options.x,datapos[1]]);break;case 'rectangle':showTooltip(plot,obj,[obj.gridStart[0],gridpos.y],[obj.options.x,datapos[1]]);break;default:break}
co.highlightObjectIndex=i;haveHighlight=!0;break}
else if(n&&co.highlightObjectIndex!==i){elem=co._tooltipElem;if(obj.fadeTooltip){elem.fadeOut(obj.tooltipFadeSpeed)}
else{elem.hide()}
switch(obj.type){case 'line':showTooltip(plot,obj,[gridpos.x,gridpos.y],datapos);break;case 'horizontalLine':case 'dashedHorizontalLine':showTooltip(plot,obj,[gridpos.x,obj.gridStart[1]],[datapos[0],obj.options.y]);break;case 'verticalLine':case 'dashedVerticalLine':showTooltip(plot,obj,[obj.gridStart[0],gridpos.y],[obj.options.x,datapos[1]]);break;case 'rectangle':showTooltip(plot,obj,[obj.gridStart[0],gridpos.y],[obj.options.x,datapos[1]]);break;default:break}
co.highlightObjectIndex=i;haveHighlight=!0;break}
else if(n){switch(obj.type){case 'line':showTooltip(plot,obj,[gridpos.x,gridpos.y],datapos);break;case 'horizontalLine':case 'dashedHorizontalLine':showTooltip(plot,obj,[gridpos.x,obj.gridStart[1]],[datapos[0],obj.options.y]);break;case 'verticalLine':case 'dashedVerticalLine':showTooltip(plot,obj,[obj.gridStart[0],gridpos.y],[obj.options.x,datapos[1]]);break;case 'rectangle':showTooltip(plot,obj,[obj.gridStart[0],gridpos.y],[obj.options.x,datapos[1]]);break;default:break}
haveHighlight=!0;break}}}
if(!haveHighlight&&co.highlightObjectIndex!==null){elem=co._tooltipElem;obj=co.getObject(co.highlightObjectIndex);if(obj.fadeTooltip){elem.fadeOut(obj.tooltipFadeSpeed)}
else{elem.hide()}
co.highlightObjectIndex=null}}
$.jqplot.postInitHooks.push($.jqplot.CanvasOverlay.postPlotInit);$.jqplot.postDrawHooks.push($.jqplot.CanvasOverlay.postPlotDraw);$.jqplot.eventListenerHooks.push(['jqplotMouseMove',handleMove])})(jQuery)